/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.network;

import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.network.ByteBufHelper;
import com.iafenvoy.jupiter.network.ClientNetworkHelper;
import com.iafenvoy.jupiter.network.NetworkConstants;
import com.iafenvoy.jupiter.util.Comment;
import com.iafenvoy.jupiter.util.TextUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;

public class ClientConfigNetwork {
    private static final Map<class_2960, Consumer<class_2487>> CALLBACKS = new HashMap<class_2960, Consumer<class_2487>>();

    public static void syncConfig(AbstractConfigContainer container) {
        ClientConfigNetwork.syncConfig(container.getConfigId(), container::deserializeNbt);
    }

    @Comment(value="will pass null to nbt if not allowed")
    public static void syncConfig(class_2960 id, Consumer<class_2487> callback) {
        CALLBACKS.put(id, callback);
        ClientNetworkHelper.INSTANCE.sendToServer(NetworkConstants.CONFIG_REQUEST_C2S, ByteBufHelper.create().method_10812(id));
    }

    public static void init() {
        ClientNetworkHelper.INSTANCE.registerReceiver(NetworkConstants.CONFIG_SYNC_S2C, (minecraft, buf) -> ClientConfigNetwork.onConfigSync(buf.method_10810(), buf.readBoolean(), buf.method_10798()));
        ClientNetworkHelper.INSTANCE.registerReceiver(NetworkConstants.CONFIG_ERROR_S2C, (minecraft, buf) -> ClientConfigNetwork.onConfigError(minecraft));
    }

    private static Runnable onConfigSync(class_2960 id, boolean allow, class_2487 data) {
        Consumer<class_2487> callback = CALLBACKS.get(id);
        if (callback == null) {
            return null;
        }
        if (allow) {
            return () -> callback.accept(data);
        }
        return () -> callback.accept(null);
    }

    private static Runnable onConfigError(class_310 minecraft) {
        return () -> minecraft.method_1566().method_1999((class_368)new class_370(class_370.class_371.field_23774, (class_2561)TextUtil.translatable("jupiter.toast.upload_config_error_title", new Object[0]), (class_2561)TextUtil.translatable("jupiter.toast.upload_config_error_content", new Object[0])));
    }
}

